texture	 g_AOMap;
texture  g_ColorBuffer;
sampler2D g_AOSamp= sampler_state
{
    Texture = <g_AOMap>;
    MinFilter = Point;
    MipFilter = Point;
    MagFilter = Point;
    AddressU = Wrap;
    AddressV = Wrap;
};
sampler2D g_CBSamp= sampler_state
{
    Texture = <g_ColorBuffer>;
    MinFilter = Point;
    MipFilter = Point;
    MagFilter = Point;
    AddressU = Clamp;
    AddressV = Clamp;
};

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

struct PostProc_VSOut
{
    float4 pos : POSITION0;
    float2 tex : TEXCOORD0;
};

//Vertex shader that generates a full screen quad with texcoords g_Rom vertIDs
//To use draw 3 vertices with primitive type triangle strip
PostProc_VSOut FullScreenQuadVS( VS_INPUT IN )
{
    PostProc_VSOut output = (PostProc_VSOut)0.0f;
    output.pos=IN.Pos;
    output.tex=IN.UV.xy;

    return output;
}

//-------------------------------------------------------------------------
float4 Modulate( PostProc_VSOut IN ): COLOR0
{
    float accesiability = tex2Dlod( g_AOSamp, float4(IN.tex,0,0)).x;
    float4 color = tex2Dlod( g_CBSamp, float4(IN.tex,0,0) );
      
	return (color*accesiability);
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique AOModulate
{
    pass P0
    {   
		VertexShader = compile vs_3_0 FullScreenQuadVS();
       	PixelShader = compile ps_3_0 Modulate();
	}
}

